﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI.WebControls;
using System.Web.Security.AntiXss;
using VIRP;
using VIRP_WEB.BaseCode;
using VIRP_WEB.SoaServices;

namespace VIRP_WEB.Custom.EFR
{
    public partial class LabResults : EfrBasePage
    {
        private int OrderType;

        protected override void Page_Load(object sender, EventArgs e)
        {
            int orderType = GetOrderType();
            if (!IsPostBack)
            {
                ReplacePageTitle("My Tasks > Lab Results > " + Enum.GetName(typeof(VIRP.EFR.BO.WorkflowCaseActivityStatus), orderType).AddSpacesToCamelCase());
                
                //For New and InProcess statuses, Accepted date does not have a value
                if (orderType == 6 || OrderType == 1)
                    GridViewLabResults.Columns[3].Visible = false;

                //For InProcess and Accepted Status display "Lab Report Date"
                if (orderType == Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.InProcess)
                        ||
                    OrderType == Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Accepted))
                {
                    GridViewLabResults.Columns[1].Visible = true;
                }

                HiddenFieldClearFlag.Value = "0";
            }

            //if (OrderType == Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.New))
            //{
            //    ObjectDataSourceGridViewLabResults.SelectMethod = "GetNewLabResults";
            //}
            //else if (OrderType == Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.InProcess))
            //{
            //    ObjectDataSourceGridViewLabResults.SelectMethod = "GetInProcessLabResults";
            //}
            //else if (OrderType == Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Accepted))
            //{
            //    ObjectDataSourceGridViewLabResults.SelectMethod = "GetCompletedLabResults";
            //}
            //else if (OrderType == Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided))
            //{
            //    ObjectDataSourceGridViewLabResults.SelectMethod = "GetVoidedLabResults";
            //}
            //ObjectDataSourceGridViewLabResults.SelectCountMethod = "GetNewLabResultsCount";
            //GridViewLabResults.DataSourceID = "ObjectDataSourceGridViewLabResults";
        }
        protected override void OnInitComplete(EventArgs e)
        {
            base.OnInitComplete(e);
        }

        protected void ObjectDataSourceGridViewLabResults_Selected(object sender, ObjectDataSourceStatusEventArgs e)
        {
            //if (((IEnumerable<LabResult>)e.ReturnValue).Count() == 0)
            if (e.ReturnValue.GetType() != null && !e.ReturnValue.GetType().IsValueType)
                if (e.ReturnValue == null || ((IEnumerable<VIRP_WEB.SoaServices.LabResult>)e.ReturnValue).Count() == 0)
                    GridViewLabResults.EmptyDataText = "No records found for the " + Enum.GetName(typeof(VIRP.EFR.BO.WorkflowCaseActivityStatus), GetOrderType()).AddSpacesToCamelCase() + " lab results.";
        }

        private int GetOrderType()
        {
            if (!IsPostBack)
            {
                OrderType = Convert.ToInt16(AntiXssEncoder.HtmlEncode(Request.QueryString["OrderType"], false));
                ViewState["OrderType"] = OrderType;
            }
            else //For paging
                OrderType = Convert.ToInt16(ViewState["OrderType"]);
            return OrderType;
        }

        protected void SelectActivity(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Details")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewLabResults.SelectedIndex = index;
                Int32 ActivityId = Convert.ToInt32(GridViewLabResults.SelectedDataKey.Values[0]);
                //WorkflowManager Wfm = new WorkflowManager();
                int WfType = GetWorkflowType(ActivityId);
                if (WfType == Convert.ToInt16(VIRP.EFR.BO.WorkFlowTypes.Biomonitoring))
                    Response.Redirect("LabResultDetails.aspx?ActivityId={0}", ActivityId);
                if (WfType == Convert.ToInt16(VIRP.EFR.BO.WorkFlowTypes.FragmentAnalysis))
                {
                    //empty session from previous contents
                    if (Helpers.SessionItemValueGet(Session["LabRptDate"]) != null)
                        Session.Remove("LabRptDate");

                    if (Helpers.SessionItemValueGet(Session["Accession"]) != null)
                        Session.Remove("Accession");

                    if (Helpers.SessionItemValueGet(Session["LabId"]) != null)
                        Session.Remove("LabId");

                    if (Helpers.SessionItemValueGet(Session["LabCode"]) != null)
                        Session.Remove("LabCode");

                    if (Helpers.SessionItemValueGet(Session["EventDate"]) != null)
                        Session.Remove("EventDate");

                    Response.Redirect("FragLabResultDetails.aspx?ActivityId={0}", ActivityId);
                }
            }
        }

        protected void ButtonClear_Click(object sender, EventArgs e)
        {
            TextBoxSearchCriteria.Text = String.Empty;
            HiddenFieldClearFlag.Value = "1";
        }

        protected void ButtonOK_Click(object sender, EventArgs e)
        {
            GridViewLabResults.PageIndex = 0;
            HiddenFieldClearFlag.Value = "0";
        }

        public int GetWorkflowType(int workFlowActivityId)
        {
            int objReturn = 0;

            WKF_CASE wkfCase = ServiceInterfaceManager.WKF_CASE_GET_BY_ACTIVITY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, workFlowActivityId);
            if (wkfCase != null)
            {
                objReturn = wkfCase.STD_WKFCASETYPE_ID;
            }

            return objReturn;
        }

        protected override void Ds_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                //e.InputParameters.Clear();

                //string txtSearch = TextBoxSearchCriteria.Text;
                //string listFacility = DropDownListFacility.SelectedValue;

                if (e.InputParameters["CURRENT_USER"] != null)
                    e.InputParameters["CURRENT_USER"] = HttpContext.Current.User.Identity.Name;
                else
                    e.InputParameters.Add("CURRENT_USER", HttpContext.Current.User.Identity.Name);

                if (e.InputParameters["CURRENT_REGISTRY_ID"] != null)
                    e.InputParameters["CURRENT_REGISTRY_ID"] = UserSession.CurrentRegistryId;
                else
                    e.InputParameters.Add("CURRENT_REGISTRY_ID", UserSession.CurrentRegistryId);

                //e.InputParameters.Add("lastName", txtSearch);
                //e.InputParameters.Add("facilityId", listFacility);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}